﻿/**************************************************************************************************
BSD License
The BSD License (http://www.opensource.org/licenses/bsd-license.php) specifies the terms and
conditions of use for FAVideo:

Copyright (c) 2007. Adobe Systems Incorporated.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:

  • Redistributions of source code must retain the above copyright notice, this list of conditions
    and the following disclaimer.
  • Redistributions in binary form must reproduce the above copyright notice, this list of
    conditions and the following disclaimer in the documentation and/or other materials provided
	with the distribution.
  • Neither the name of Adobe Systems Incorporated nor the names of its contributors may be used
    to endorse or promote products derived from this software without specific prior written
	permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIESOF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


For more information and updates for FAVideo, please visit:
http://www.adobe.com/go/favideo/
**************************************************************************************************/

/**
*  VideoState, this is modified from the original fl.video.VideoState class that is used by Flash 9's FLVPlayback component.
*/
class com.adobe.favideo.VideoState {
	
	/**
	 * The video player is in the disconnected state.
			 * It enters this state when the stream is closed by a call 
			 * to the <code>closeVideoPlayer()</code>
	 * method or timed out on idle.
	 */
	public static var DISCONNECTED:String = "disconnected";

	/**
	 * The video player is in the stopped state.
	 * It enters this state when the FLV file is loaded and 
	 * play is stopped by calling the <code>stop()</code> method or when the
	 * playhead reaches the end of the stream.
	 *
	 * <p>This is a responsive state.</p>
	 */
	public static var STOPPED:String = "stopped";

	/**
	 * The video player is in the playing state.
	 * It enters this state when the FLV file is loaded and is playing.
	 *
	 * <p>This is a responsive state.</p>
	 */
	public static var PLAYING:String = "playing";

	/**
	 * The video player is in the paused state.
	 * It enters this state when the FLV file is loaded, but play is paused
	 * by calling the <code>pause()</code> or
	 * <code>load()</code> method.
	 *
	 * <p>This is a responsive state.</p>
	 */
	public static var PAUSED:String = "paused";

	/**
	 * The video player is in the buffering state. 
	 * It enters this state immediately 
	 * after a call is made to the <code>play()</code> or <code>load()</code> method.
	 *
	 * <p>This is a responsive state.</p>
	 */
	public static var BUFFERING:String = "buffering";

	/**
	 * The video player is in the loading state. 
	 * It enters this state immediately after the
	 * <code>play()</code> or <code>load()</code> method is called or
	 * after the <code>source</code> property is set.
	 *
	 * <p>This is an unresponsive state.</p>
	 */
	public static var LOADING:String = "loading";

	/**
	 * The video player is in the connection error state.
	 * It enters this state when a video stream attempted to 
	 * load but was unsuccessful. There are two possible reasons for the error: 
	 * no connection to the server or the stream was not found.
	 *
	 * <p>This is an unresponsive state.</p>
	 */
	public static var CONNECTION_ERROR:String = "connectionError";
	
	/**
	 * The video player is in the seeking state.
	 * It enters this state after the <code>seek()</code> method
	 * is called and also while the user is scrubbing with the seek bar.
	 * 
	 * <p>This is an unresponsive state.</p>
	 */
	public static var SEEKING:String = "seeking";
	
	/**
	 * The video player is in the rewinding state.
	 * It enters this state when the video rewinds automatically.
	 * The video rewinds automatically after it has stopped, either
	 * by clicking the stop button or by the video playing to the end. 
	 * After rewinding is complete, the state is stopped.
	 *
	 * <p>This is an unresponsive state.</p>
	 */
	public static var REWINDING:String = "rewinding";
	
}