/**
*Resource Manager class
*For working with AWS S3 buckets
**/


function ResourceManager()
{

    this.bucket = 'psionspyglass';
    var self = this;
    this.s3 = new AWS.S3({ region: 'us-east-1' });


    /*var getObjectPromise = self.s3.getObject({ Bucket: self.bucket, Key: 'contents/' }).promise();
    //function will triggern the correct callback function
    getObjectPromise.then(function(data){
        alert("AWS bucket ready");
    },
    function(error){
      //this is the error that occurs when changing pages after an hour has elapsed???
      console.log(error);
        alert("Unable to reach AWS bucket "+error);
      //loadPage();
    }) */

    this.getResource=function(dir)
    {
       if(dir)key=dir.replace('./','');
       resource="";
       self.s3.getSignedUrl('getObject', {Bucket:self.bucket, Key:key}, function (err, url) {
          if(err){
              console.log(err);
              loadPage();
          }
          else resource=url;
       });
       return resource;
    }

    this.getFiles=function(directory,item)
    {
        var key=directory+"/";
        self.s3.listObjectsV2({Bucket:self.bucket,Prefix:key,StartAfter:key}, function(err, data) {
         if(err){
              console.log(err);
              loadPage();
          }
          else vm.directory.display(data,directory,item);

        })
    }

    this.newDirectory=function(directory,name)
    {
        var key=directory+"/"+name+"/";
        self.s3.putObject({Bucket:self.bucket, Key:key},function(err){
         if(err){
              console.log(err);
              loadPage();
          }
          else self.getFiles(directory,name);
        })
    }

    this.deleteObjects=function(directory,keys)
    {
        for(i=0;i<keys.length;i++){
          self.s3.deleteObject({Bucket:self.bucket, Key:keys[i]}, function(err, data) {
          if(err){
              alert("Error: "+err);
           }
           else self.getFiles(directory);
          });
        }

    }

    this.pasteObjects=function(from,to,mode,items)
    {
        for(i=0;i<items.length;i++){
          var key=from+"/"+items[i].path;
          var name=items[i].path;
          var type=items[i].type;
          self.copyRecursive(key,name,type,to);
          //if mode=cut then delete 'from' objects
          if(mode=="cut"){
            self.s3.deleteObject({Bucket:self.bucket, Key:key}, function(err, data) {
               if(err){
                   alert("Error: "+err);
               }
            });
          }
        }

    }

    this.copyRecursive=function(key,name,type,to){
        var copyto=to+"/"+name;
        if(type=="file"){

          self.s3.copyObject({Bucket:self.bucket,CopySource:"/"+self.bucket+"/"+key,Key:copyto}, function(err, data) {
             if (err) alert(err+" "+err.stack);
             else{
                 self.getFiles(to);
             }
          });

        }

    }

    this.uploadFiles=function(directory,files)
    {
         var key=directory+"/"
         for(i=0;i<files.length;i++){
            self.upload=self.s3.upload({Bucket:self.bucket,Key: key+files[i].name, ContentType: files[i].type, Body: files[i]}, function (err, data) {
               if (err) alert(err+" "+err.stack);
               else{
                  self.extractText(key+files[files.length-1].name);
                  self.getFiles(directory,files[files.length-1].name);
               }
            });
         }
         self.upload.on('httpUploadProgress', function (progress) {
               //console.log(progress.loaded + " of " + progress.total + " bytes");
               var val=Math.floor((progress.loaded/progress.total)*100);
               $('#progressbar').progressbar( "value", val);

         });

    }

    this.extractText=function(key)
    {
       self.s3.getSignedUrl('getObject', {Bucket:self.bucket, Key:key}, function (err, url) {
          if(err){
              console.log(err);
              loadPage();
          }
          else{
                function gettext(pdfUrl){
                var pdf = PDFJS.getDocument(pdfUrl);
                return pdf.then(function(pdf) { // get all pages text
                     var maxPages = pdf.pdfInfo.numPages;
                     var fingerprint = pdf.pdfInfo.fingerprint;
                     var countPromises = []; // collecting all page promises
                     for (var j = 1; j <= maxPages; j++) {
                        var page = pdf.getPage(j);

                        var txt = "";
                        countPromises.push(page.then(function(page) { // add page promise
                            var textContent = page.getTextContent();
                            return textContent.then(function(text){ // return content promise
                                return text.items.map(function (s) { return s.str; }).join(''); // value page text 

                            });
                        }));
                     }
                     // Wait for all pages and join text
                     return Promise.all(countPromises).then(function (texts) {
                       
                       return fingerprint+" - "+texts.join('');
                     });
                });
                }
                // waiting on gettext to finish completion, or error
                gettext(url).then(function (text) {
                  alert('parse ' + text);
                }, function (reason) {
                  console.error(reason);
                });
          }
       })


    }


}